/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.service.serviceaction;

import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionException;
import com.ibm.hwmca.fw.service.statetransition.Context;
import com.ibm.hwmca.fw.service.statetransition.Engine;
import com.ibm.hwmca.fw.service.statetransition.Result;
import com.ibm.hwmca.fw.service.statetransition.StateTransitionSupport;
import com.ibm.hwmca.fw.service.statetransition.StateTransitionSupportException;
import com.ibm.hwmca.fw.service.statetransition.Variable;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.service.PETrace;
import com.ibm.hwmca.xfw.service.SD;
import com.ibm.hwmca.xfw.service.panel.PBCommonGenericMessage;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ServiceActionStateEngine {
    private static final String TRACE_MASKT = "XRVSASET";
    private static final String TRACE_MASKF = "XRVSASEF";
    private static final String TRACE_MASKD = "XRVSASED";

    private ServiceActionStateEngine() {
    }

    public static void fire(File rulesFile, Context parentContext, Map userData) throws ServiceActionException {
        Context previousContext = (Context)userData.get("STS_CONTEXT");
        try {
            Trace.trace(TRACE_MASKT, "-> ServiceActionStateEngine.fire( File=" + rulesFile + ", parentContext, Map )");
            Context context = StateTransitionSupport.parseRules(rulesFile, parentContext);
            Trace.trace(TRACE_MASKF, "ServiceActionStateEngine.fire got the context");
            context.setUserData(userData);
            if (userData.get(SD.KEY_SERVICE_DATA) == null) {
                Trace.trace(TRACE_MASKD, "ServiceActionStateEngine.fire setting up service data container");
                SD serviceData = new SD();
                userData.put(SD.KEY_SERVICE_DATA, serviceData);
            } else {
                Trace.trace(TRACE_MASKD, "ServiceActionStateEngine.fire service data previously set in user map - using it");
            }
            userData.put("STS_CONTEXT", context);
            ServiceActionStateEngine.fire(context);
            userData.put("STS_CONTEXT", previousContext);
        }
        catch (Exception e) {
            userData.put("STS_CONTEXT", previousContext);
            Trace.trace(TRACE_MASKT, "<-! ServiceActionStateEngine.fire Exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            if (e instanceof ServiceActionException) {
                throw (ServiceActionException)e;
            }
            throw new ServiceActionException(e);
        }
        Trace.trace(TRACE_MASKT, "<- ServiceActionStateEngine.fire( File[], parentContext, Map )");
    }

    public static void fire(File rulesFile, Map userData) throws ServiceActionException {
        Trace.trace(TRACE_MASKT, "-> ServiceActionStateEngine.fire( File=" + rulesFile + ", Map )");
        ServiceActionStateEngine.fire(rulesFile, null, userData);
        Trace.trace(TRACE_MASKT, "<- ServiceActionStateEngine.fire( File[], Map )");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fire(Context context) throws ServiceActionException {
        Trace.trace(TRACE_MASKT, "-> ServiceActionStateEngine.fire( Context )");
        String currentStateName = "**NOT SET**";
        boolean done = false;
        boolean errorpass = false;
        Engine engine = StateTransitionSupport.createEngine();
        while (!done) {
            try {
                String currentState;
                Variable previousStateVariable;
                Variable currentStateVariable;
                Object var11_14;
                List results = engine.fire(context);
                Result result = null;
                Trace.trace(TRACE_MASKF, "ServiceActionStateEngine: results:[" + results + "]");
                if (results.size() > 1) {
                    String trueRules = "/";
                    Iterator it = results.iterator();
                    while (it.hasNext()) {
                        String ruleName = ((Result)it.next()).getRuleName();
                        trueRules = trueRules + ruleName + "/";
                    }
                    Trace.trace(TRACE_MASKF, "ServiceActionStateEngine: multiple repair rules true: " + trueRules);
                    PETrace.petrace(context.getUserData(), "multiple repair rules true: " + trueRules);
                    throw new ServiceActionException("ERROR: multiple repair rules true: " + trueRules);
                }
                if (results.size() == 0) {
                    Trace.trace(TRACE_MASKF, "ServiceActionStateEngine: ERROR: NO rules returned true");
                    PETrace.petrace(context.getUserData(), "ERROR: NO rules returned true - exiting state loop");
                    done = true;
                    break;
                }
                result = (Result)results.get(0);
                currentStateName = result.getRuleName();
                PETrace.petrace(context.getUserData(), "new state " + currentStateName + ", firing effector");
                Trace.trace(TRACE_MASKF, "!!! FIRING EFFECTOR for TRUE RULE: " + currentStateName);
                Map userData = context.getUserData();
                if (userData != null) {
                    userData.put(SD.CURRENT_STATE_VARIABLE, currentStateName);
                }
                try {
                    result.fireEffector(context);
                    var11_14 = null;
                    currentStateVariable = context.getVariable(SD.CURRENT_STATE_VARIABLE);
                    previousStateVariable = context.getVariable(SD.PREVIOUS_STATE_VARIABLE);
                }
                catch (Throwable throwable) {
                    var11_14 = null;
                    currentStateVariable = context.getVariable(SD.CURRENT_STATE_VARIABLE);
                    previousStateVariable = context.getVariable(SD.PREVIOUS_STATE_VARIABLE);
                    previousStateVariable.setValue(currentStateVariable.getValue());
                    currentState = result.getRuleName();
                    currentStateVariable.setValue(currentState);
                    if (currentState.equals(SD.EXIT)) {
                        done = true;
                    }
                    throw throwable;
                }
                previousStateVariable.setValue(currentStateVariable.getValue());
                currentState = result.getRuleName();
                currentStateVariable.setValue(currentState);
                if (currentState.equals(SD.EXIT)) {
                    done = true;
                }
                PETrace.petrace(context.getUserData(), "effector for state " + currentStateName + " complete without exceptions");
                Trace.trace(TRACE_MASKF, "!!! EFFECTOR COMPLETE for TRUE RULE: " + currentStateName);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "ServiceActionStateEngine.fire exception caught: " + e);
                Trace.trace(TRACE_MASKF, e);
                PETrace.petrace(context.getUserData(), "exception caught processing state: " + currentStateName);
                PETrace.petrace(context.getUserData(), e);
                if (errorpass) {
                    Trace.trace(TRACE_MASKT, "<-! ServiceActionStateEngine.fire exception on error recovery path");
                    if (e instanceof ServiceActionException) {
                        throw (ServiceActionException)e;
                    }
                    throw new ServiceActionException(e);
                }
                Map userData = context.getUserData();
                if (userData != null) {
                    GenericGui guiHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
                    if (guiHandle != null) {
                        Throwable currentException = e;
                        String debugMessage = "";
                        int jii = 0;
                        do {
                            StackTraceElement[] stackTrace;
                            if ((stackTrace = currentException.getStackTrace()) == null) continue;
                            debugMessage = debugMessage + "Exception text(" + jii++ + "):" + currentException.getMessage() + "\n";
                            for (int aii = 0; aii < stackTrace.length; ++aii) {
                                debugMessage = debugMessage + stackTrace[aii].toString() + "\n";
                            }
                            debugMessage = debugMessage + "---------------------------------\n";
                        } while ((currentException = currentException.getCause()) != null);
                        PBCommonGenericMessage exceptionDialogBean = new PBCommonGenericMessage();
                        exceptionDialogBean.setEditBoxText(debugMessage);
                        HashMap<String, String> displayMap = new HashMap<String, String>();
                        displayMap.put("message", "Error detected");
                        exceptionDialogBean.setText("An unexpected error has been detected.");
                        exceptionDialogBean.setDataMap(displayMap);
                        try {
                            guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", exceptionDialogBean.getTemplateName(), exceptionDialogBean, userData);
                        }
                        catch (Exception toss) {
                            Trace.trace(TRACE_MASKF, "ServiceActionStateEngine.fire exception displaying dialog - ignoring it");
                            Trace.trace(TRACE_MASKF, toss);
                        }
                    } else {
                        Trace.trace(TRACE_MASKT, "ServiceActionStateEngine.fire exception caught, but no GUI available to show stack trace");
                    }
                } else {
                    Trace.trace(TRACE_MASKT, "ServiceActionStateEngine.fire exception caught, but no global data map available (can't show stack trace)");
                }
                errorpass = true;
                Variable overallStatus = context.getVariable(SD.OVERALL_STATUS_VARIABLE);
                if (overallStatus != null) {
                    try {
                        overallStatus.setValue(SD.NEW_PROBLEM_DETECTED);
                    }
                    catch (StateTransitionSupportException ste) {
                        Trace.trace(TRACE_MASKT, "<-! ServiceActionStateEngine.fire unable to set OVERALL_STATUS=NEW_PROBLEM_DETECTED. Exception caught: " + ste);
                        throw new ServiceActionException("unable to set OVERALL_STATUS=NEW_PROBLEM_DETECTED. Exception caught: " + ste);
                    }
                }
                Trace.trace(TRACE_MASKF, "ServiceActionStateEngine.fire redriving loop with OVERALL_STATUS=NEW_PROBLEM_DETECTED");
            }
        }
        Trace.trace(TRACE_MASKT, "<- ServiceActionStateEngine.fire( Context )");
    }
}

